/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.crumbling;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.GlTextureUnit;
import com.jozufozu.flywheel.backend.instancing.InstanceManager;
import com.jozufozu.flywheel.backend.instancing.SerialTaskEngine;
import com.jozufozu.flywheel.backend.instancing.instancing.InstancingEngine;
import com.jozufozu.flywheel.core.Contexts;
import com.jozufozu.flywheel.core.crumbling.CrumblingGroup;
import com.jozufozu.flywheel.core.crumbling.CrumblingInstanceManager;
import com.jozufozu.flywheel.core.crumbling.CrumblingProgram;
import com.jozufozu.flywheel.event.ReloadRenderersEvent;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.jozufozu.flywheel.mixin.LevelRendererAccessor;
import com.jozufozu.flywheel.util.Lazy;
import com.jozufozu.flywheel.util.Pair;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class CrumblingRenderer {
    static RenderType _currentLayer;
    private static final Lazy<State> STATE;
    private static final Lazy.KillSwitch<State> INVALIDATOR;

    public static void renderBreaking(RenderLayerEvent event) {
        if (!Backend.canUseInstancing((Level)event.getWorld())) {
            return;
        }
        Int2ObjectMap<List<BlockEntity>> activeStages = CrumblingRenderer.getActiveStageBlockEntities(event.getWorld());
        if (activeStages.isEmpty()) {
            return;
        }
        State state = STATE.get();
        InstanceManager<BlockEntity> instanceManager = state.instanceManager;
        InstancingEngine<CrumblingProgram> materials = state.materialManager;
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        Camera info = Minecraft.m_91087_().f_91063_.m_109153_();
        for (Int2ObjectMap.Entry stage : activeStages.int2ObjectEntrySet()) {
            _currentLayer = (RenderType)ModelBakery.f_119229_.get(stage.getIntKey());
            if (_currentLayer == null) continue;
            ((List)stage.getValue()).forEach(instanceManager::add);
            instanceManager.beginFrame(SerialTaskEngine.INSTANCE, info);
            materials.render(SerialTaskEngine.INSTANCE, event);
            instanceManager.invalidate();
        }
        GlTextureUnit.T0.makeActive();
        AbstractTexture breaking = textureManager.m_118506_((ResourceLocation)ModelBakery.f_119228_.get(0));
        if (breaking != null) {
            RenderSystem.m_69396_((int)breaking.m_117963_());
        }
    }

    private static Int2ObjectMap<List<BlockEntity>> getActiveStageBlockEntities(ClientLevel world) {
        Int2ObjectArrayMap breakingEntities = new Int2ObjectArrayMap();
        for (Long2ObjectMap.Entry entry : ((LevelRendererAccessor)Minecraft.m_91087_().f_91060_).flywheel$getDestructionProgress().long2ObjectEntrySet()) {
            BlockPos breakingPos = BlockPos.m_122022_((long)entry.getLongKey());
            SortedSet progresses = (SortedSet)entry.getValue();
            if (progresses == null || progresses.isEmpty()) continue;
            int blockDamage = ((BlockDestructionProgress)progresses.last()).m_139988_();
            BlockEntity blockEntity = world.m_7702_(breakingPos);
            if (blockEntity == null) continue;
            List blockEntities = (List)breakingEntities.computeIfAbsent(blockDamage, $ -> new ArrayList());
            blockEntities.add(blockEntity);
        }
        return breakingEntities;
    }

    @SubscribeEvent
    public static void onReloadRenderers(ReloadRenderersEvent event) {
        ClientLevel world = event.getWorld();
        if (Backend.isOn() && world != null) {
            CrumblingRenderer.reset();
        }
    }

    public static void reset() {
        INVALIDATOR.killValue();
    }

    static {
        Pair<Lazy<State>, Lazy.KillSwitch<State>> state = Lazy.ofKillable(State::new, State::kill);
        STATE = state.first();
        INVALIDATOR = state.second();
    }

    private static class State {
        private final InstancingEngine<CrumblingProgram> materialManager = InstancingEngine.builder(Contexts.CRUMBLING).setGroupFactory(CrumblingGroup::new).build();
        private final InstanceManager<BlockEntity> instanceManager = new CrumblingInstanceManager(this.materialManager);

        private State() {
            this.materialManager.addListener(this.instanceManager);
        }

        private void kill() {
            this.materialManager.delete();
            this.instanceManager.invalidate();
        }
    }
}

